def next_note_idx(idx, next_idx):
    rounded_idx = idx % 7

    if next_idx > rounded_idx:
        if next_idx - rounded_idx <= 3:
            return idx + next_idx - rounded_idx
        else:
            return idx - (7 - (next_idx - rounded_idx))
    else:
        if rounded_idx - next_idx <= 3:
            return idx + next_idx - rounded_idx
        else:
            return idx - (7 - (next_idx - rounded_idx))


line_count = int(input())

order = {
    'A': 0,
    'B': 1,
    'C': 2,
    'D': 3,
    'E': 4,
    'F': 5,
    'G': 6
}


for _ in range(line_count):
    composition = input()

    first_note = composition[0]
    first_note_idx = order[first_note]
    octaves = []

    while first_note_idx < 51:
        octaves.append(first_note_idx)
        first_note_idx += 7

    for note in composition[1:]:
        for i in range(len(octaves)):
            if octaves[i] <= -1 or octaves[i] > 51:
                continue

            octaves[i] = next_note_idx(octaves[i], order[note])

    if len(list(filter(lambda x: 0 <= x < 52, octaves))) != 0:
        print("yes")
    else:
        print("no")
