#include <iostream>
#include <vector>
#include <unordered_set>
#include <unordered_map>  
#include <cmath>
#include <string>        

using namespace std;

bool can_play_melody(const string& melody, const unordered_map<char, vector<int>>& key_positions) {
    if (melody.empty()) return true;  

    unordered_set<int> possible_keys(key_positions.at(melody[0]).begin(),
                                     key_positions.at(melody[0]).end());

    for (size_t i = 1; i < melody.size(); ++i) {
        unordered_set<int> next_keys;
        if (key_positions.find(melody[i]) == key_positions.end()) {
            
            return false;
        }

        for (int k : key_positions.at(melody[i])) {
            for (int prev : possible_keys) {
                if (abs(k - prev) <= 3) {
                    next_keys.insert(k);
                    break;
                }
            }
        }
        if (next_keys.empty()) {
            return false;
        }
        possible_keys = move(next_keys);
    }
    return true;
}

int main() {
    int t;
    cin >> t;
    cin.ignore();  

    vector<string> melodies(t);
    for (int i = 0; i < t; ++i) {
        getline(cin, melodies[i]);
    }

    unordered_map<char, vector<int>> key_positions = {
        {'A', {1, 8, 15, 22, 29, 36, 43, 50}},
        {'B', {2, 9, 16, 23, 30, 37, 44, 51}},
        {'C', {3, 10, 17, 24, 31, 38, 45, 52}},
        {'D', {4, 11, 18, 25, 32, 39, 46}},
        {'E', {5, 12, 19, 26, 33, 40, 47}},
        {'F', {6, 13, 20, 27, 34, 41, 48}},
        {'G', {7, 14, 21, 28, 35, 42, 49}}
    };

    for (const string& melody : melodies) {
        cout << (can_play_melody(melody, key_positions) ? "Yes" : "No") << endl;
    }

    return 0;
}
