import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class Main {
    static class FastReader {
        BufferedReader br;
        StringTokenizer st;
        FastReader() {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        String next() {
            try {
                while(st == null || !st.hasMoreElements()) {
                    st = new StringTokenizer(br.readLine());
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return st.nextToken();
        }
        Integer nextInt() {
            return Integer.parseInt(next());
        }
        Long nextLong() {
            return Long.parseLong(next());
        }
        String nextLine() {
            String str = "";
            try {
                str = br.readLine();
            } catch(IOException e) {
                e.printStackTrace();
            }
            return str;
        }
    }
    static FastReader scan = new FastReader();
    public static void main(String[] args) {
        int n = scan.nextInt();
        long[] arr = new long[n];
        for(int i = 0; i < n; i++) arr[i] = scan.nextLong();
        long mx = 0, mn = (long) 1e17;
        for(int i = 0; i < (1L << (n + 1)); i++) {
            long a = 0, b = 0;
            for(int j = 0; j < n; j++) {
                if((i & (1L << j)) > 0) a += arr[j];
                else b += arr[j];
            }
            if(a == 0 || b == 0) continue;
            mx = Math.max(a * b, mx);
            mn = Math.min(a * b, mn);
        }
        System.out.println(mn + " " + mx);
    }
}