import math
from math import gcd
def normalize(a, b):
    if a == 0 and b == 0:
        return (0, 0)
    g = gcd(abs(a), abs(b))
    a //= g
    b //= g
    if a < 0 or (a == 0 and b < 0):
        a = -a
        b = -b
    return (a, b)
def solve():
    n = int(input())
    poi = []
    for _ in range(n):
        x, y = map(int, input().split())
        poi.append((x, y))
    best_dist_sq = -1
    best_line1 = None
    best_line2 = None
    for i in range(n):
        for j in range(i + 1, n):
            x1, y1 = poi[i]
            x2, y2 = poi[j]
            dx = x2 - x1
            dy = y2 - y1
            normals = [
                (dy, -dx),
                (-dy, dx),
                (dx, dy),
                (-dx, -dy)
            ]

            for a, b in normals:
                if a == 0 and b == 0:
                    continue

                a_norm, b_norm = normalize(a, b)
                if a_norm == 0 and b_norm == 0:
                    continue

                vals = [a_norm * x + b_norm * y for x, y in poi]
                min_v = min(vals)
                max_v = max(vals)

                dist_sq = (max_v - min_v) ** 2 / (a_norm*a_norm + b_norm*b_norm)

                if dist_sq > best_dist_sq:
                    best_dist_sq = dist_sq
                    best_line1 = (a_norm, b_norm, -min_v)
                    best_line2 = (a_norm, b_norm, -max_v)

    print(*best_line1)
    print(*best_line2)

solve()
