def mod_inverse(a, m):
    def extended_gcd(a, b):
        if a == 0:
            return b, 0, 1
        gcd, x1, y1 = extended_gcd(b % a, a)
        x = y1 - (b // a) * x1
        y = x1
        return gcd, x, y
    
    _, x, _ = extended_gcd(a, m)
    return (x % m + m) % m

MOD = 10**9 + 7

def solve(p, m):
    num = 2 * (m + 1) % MOD
    num = (num * (2 * p + m + 1)) % MOD
    denom = (p + 1) % MOD
    denom = (denom * (2 * p + m)) % MOD
    inv_denom = mod_inverse(denom, MOD)
    result = (num * inv_denom) % MOD
    return result

t = int(input())
for _ in range(t):
    p, m = map(int, input().split())
    print(solve(p, m))
