#include <iostream>
#include <vector>
#include <cmath>
#include <limits>
using namespace std;

int main() {
    int n;
    cin >> n;

    vector<pair<int, int>> ps(n);
    for (int i = 0; i < n; ++i) {
        cin >> ps[i].first >> ps[i].second;
    }

    double mdist = -1.0;
    pair<array<double, 3>, array<double, 3>> best;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;

            double dx = ps[j].first - ps[i].first;
            double dy = ps[j].second - ps[i].second;
            double a = dx;
            double b = dy;

            vector<double> arr;
            arr.reserve(n);
            for (auto& p : ps) {
                arr.push_back(a * p.first + b * p.second);
            }

            double mi = numeric_limits<double>::infinity();
            double ma = -numeric_limits<double>::infinity();

            for (double v : arr) {
                if (v < mi) mi = v;
                if (v > ma) ma = v;
            }

            double dist = (a != 0 || b != 0) ? (ma - mi) / sqrt(a * a + b * b) : 0.0;

            if (dist > mdist) {
                mdist = dist;
                double c1 = -ma;
                double c2 = -mi;
                if (c1 > c2) swap(c1, c2);
                best = { {a, b, c1}, {a, b, c2} };
            }
        }
    }

    for (auto& i : {best.first, best.second}) {
        cout << i[0] << " " << i[1] << " " << i[2] << "\n";
    }

    return 0;
}
