import java.io.*;
import java.util.*;

public class Main {
        public static void main(String[] args) {
            Scanner sc = new Scanner(System.in);
            int n = sc.nextInt();
            int[] pairs = new int[n];
            for (int i = 0; i < n; i++) {
                pairs[i] = sc.nextInt();
            }
            long minArrea = Long.MAX_VALUE;
            long maxArrea = 0;
            int total = 1 << n;
            long[] h = new long[total];

            for (int mask = 0; mask < total; mask++) {
                long sum = 0;
                for (int i = 0; i < n; i++) {
                    if ((mask & (1 << i)) != 0) {
                        sum += 2L * pairs[i];
                    }
                }
                h[mask] = sum;
            }
            for (int mask = 0; mask < total; mask++) {
                long hor = h[mask];
                if (hor == 0) continue;
                long ver = 0;
                for (int i = 0; i < n; i++) {
                    if ((mask & (1 << i)) == 0) {
                        ver += 2L * pairs[i];
                    }
                }

                if (ver > 0) {
                    long arrea = hor * ver / 4;
                    minArrea = Math.min(minArrea, arrea);
                    maxArrea = Math.max(maxArrea, arrea);
                }
            }

            System.out.println(minArrea + " " + maxArrea);
        }

    public static class MyScanner {
        BufferedReader br;
        StringTokenizer st;

        public MyScanner() {
            br = new BufferedReader(new InputStreamReader(System.in));
        }

        String next() {
            while (st == null || !st.hasMoreElements()) {
                try {
                    st = new StringTokenizer(br.readLine());
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return st.nextToken();
        }

        int nextInt() {
            return Integer.parseInt(next());
        }

        long nextLong() {
            return Long.parseLong(next());
        }

        double nextDouble() {
            return Double.parseDouble(next());
        }

        String nextLine() {
            String str = "";
            try {
                if (st != null && st.hasMoreTokens()) {
                    str = st.nextToken("\n");
                } else {
                    str = br.readLine();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return str;
        }

        // ДОБАВИТЕ этот метод для проверки наличия следующего элемента
        public boolean hasNext() {
            try {
                if (st != null && st.hasMoreTokens()) {
                    return true;
                }
                // Проверяем, готов ли BufferedReader и есть ли еще данные
                if (!br.ready()) {
                    return false;
                }
                // Если st пустой, пытаемся заполнить его
                while (st == null || !st.hasMoreTokens()) {
                    String line = br.readLine();
                    if (line == null) return false;
                    st = new StringTokenizer(line);
                }
                return true;
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}