﻿#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 3000005;

int fac[MAX], inv_fac[MAX], pow2[MAX];

int mod_pow(int a, int b) {
    int res = 1;
    while (b) {
        if (b & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fac[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fac[i] = 1LL * fac[i - 1] * i % MOD;
    }
    inv_fac[MAX - 1] = mod_pow(fac[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; i--) {
        inv_fac[i] = 1LL * inv_fac[i + 1] * (i + 1) % MOD;
    }

    pow2[0] = 1;
    for (int i = 1; i < MAX; i++) {
        pow2[i] = 2LL * pow2[i - 1] % MOD;
    }
}

int comb(int n, int k) {
    if (k < 0 || k > n) return 0;
    return 1LL * fac[n] * inv_fac[k] % MOD * inv_fac[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    precompute();
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        int N = 2 * p + m;

        long long total = 0;
        int small = min(p, m);
        int large = max(p, m);

        if (p <= m) {
            vector<int> T(p + 1);
            for (int r = 0; r <= p; r++) {
                T[r] = 1LL * comb(p, r) * pow2[r] % MOD;
            }

            vector<int> C_m(m + 1);
            for (int s = 0; s <= m; s++) {
                C_m[s] = comb(m, s);
            }

            for (int k = 0; k <= p + m; k++) {
                long long sum = 0;
                int start = max(0, k - m);
                int end = min(p, k);
                int r = start;
                for (; r + 3 <= end; r += 4) {
                    sum = (sum + 1LL * T[r] * C_m[k - r] +
                        1LL * T[r + 1] * C_m[k - r - 1] +
                        1LL * T[r + 2] * C_m[k - r - 2] +
                        1LL * T[r + 3] * C_m[k - r - 3]) % MOD;
                }
                for (; r <= end; r++) {
                    sum = (sum + 1LL * T[r] * C_m[k - r]) % MOD;
                }
                int denom = comb(N, k);
                total = (total + sum * mod_pow(denom, MOD - 2)) % MOD;
            }
        }
        else {
            vector<int> C_m(m + 1);
            for (int s = 0; s <= m; s++) {
                C_m[s] = comb(m, s);
            }
            for (int k = 0; k <= p + m; k++) {
                long long sum = 0;
                int start = max(0, k - m);
                int end = min(p, k);
                if (start <= end) {
                    long long T_curr;
                    if (start == 0) {
                        T_curr = 1;
                    }
                    else {
                        T_curr = 1LL * comb(p, start) * mod_pow(2, start) % MOD;
                    }

                    sum = 1LL * T_curr * C_m[k - start] % MOD;

                    for (int r = start + 1; r <= end; r++) {
                        T_curr = 1LL * T_curr * (p - r + 1) % MOD;
                        T_curr = 1LL * T_curr * 2 % MOD;
                        T_curr = 1LL * T_curr * mod_pow(r, MOD - 2) % MOD;
                        sum = (sum + 1LL * T_curr * C_m[k - r]) % MOD;
                    }
                }

                int denom = comb(N, k);
                total = (total + sum * mod_pow(denom, MOD - 2)) % MOD;
            }
        }

        cout << total % MOD << "\n";
    }

    return 0;
}