import java.util.Scanner;

public class Main {
    private static final String PIANO = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGAB";

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int t = scanner.nextInt();
        scanner.nextLine();

        for (int i = 0; i < t; i++) {
            String melody = scanner.nextLine();
            System.out.println(canPlay(melody) ? "Yes" : "No");
        }
        scanner.close();
    }

    private static boolean canPlay(String melody) {
        char first = melody.charAt(0);

        for (int start = 0; start < PIANO.length(); start++) {
            if (PIANO.charAt(start) == first && (start == 0 || PIANO.charAt(start - 1) != first)) {
                if (checkPath(melody, start)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkPath(String melody, int startPos) {
        int currentPos = startPos;

        for (int i = 1; i < melody.length(); i++) {
            char target = melody.charAt(i);
            int nextPos = findNextPosition(currentPos, target);
            if (nextPos == -1) return false;
            currentPos = nextPos;
        }
        return true;
    }

    private static int findNextPosition(int currentPos, char target) {
        if (PIANO.charAt(currentPos) == target) {
            return currentPos;
        }
        for (int dist = 1; dist <= 3; dist++) {
            if (currentPos + dist < PIANO.length() && PIANO.charAt(currentPos + dist) == target) {
                return currentPos + dist;
            }
            if (currentPos - dist >= 0 && PIANO.charAt(currentPos - dist) == target) {
                return currentPos - dist;
            }
        }
        return -1;
    }
}