import sys
from math import gcd

input = sys.stdin.readline

def normalize(a, b, c):
    g = gcd(abs(a), gcd(abs(b), abs(c)))
    if g == 0:
        return 0, 0, 0
    a //= g
    b //= g
    c //= g
    if a < 0 or (a == 0 and b < 0):
        a, b, c = -a, -b, -c
    return a, b, c

def main():
    line = input().strip()
    while not line:
        line = input().strip()
    n = int(line)
    points = []
    for _ in range(n):
        line = input().strip()
        while not line:
            line = input().strip()
        parts = line.split()
        x = int(parts[0])
        y = int(parts[1])
        points.append((x, y))

    best_dist2 = -1
    best_i = -1
    best_j = -1
    for i in range(n):
        for j in range(i + 1, n):
            dx = points[j][0] - points[i][0]
            dy = points[j][1] - points[i][1]
            dist2 = dx * dx + dy * dy
            if dist2 > best_dist2:
                best_dist2 = dist2
                best_i = i
                best_j = j

    p1 = points[best_i]
    p2 = points[best_j]
    dx = p2[0] - p1[0]
    dy = p2[1] - p1[1]
    c1 = -(dx * p1[0] + dy * p1[1])
    c2 = -(dx * p2[0] + dy * p2[1])

    a1, b1, c1n = normalize(dx, dy, c1)
    a2, b2, c2n = normalize(dx, dy, c2)

    print(a1, b1, c1n)
    print(a2, b2, c2n)

if __name__ == "__main__":
    main()