#include <bits/stdc++.h>
using namespace std;

struct Axial {
  int q, r;
};
struct Cube {
  int x, y, z;
};

static inline Cube axial_to_cube(Axial a) { return {a.q, -a.q - a.r, a.r}; }
static inline Axial cube_to_axial(Cube c) { return {c.x, c.z}; }

static inline Cube rot_cw(Cube c) { return Cube{-c.z, -c.x, -c.y}; }
static inline Cube rot_ccw(Cube c) { return Cube{-c.y, -c.z, -c.x}; }
static inline Cube mirror_T(Cube c) { return Cube{c.y, c.x, c.z}; }

int main() {
  int n;
  cin >> n;
  const int k = n - 1;

  auto q_min_for = [&](int r) -> int { return max(-k, -r - k); };
  auto q_max_for = [&](int r) -> int { return min(k, -r + k); };

  unordered_map<long long, int> val;
  val.reserve(3 * n * (n - 1) + 1);
  auto key = [](int q, int r) -> long long {
    return ((long long)(q + 600000) << 21) ^ (long long)(r + 600000);
  };

  for (int r = -k; r <= k; ++r) {
    int ql = q_min_for(r), qr = q_max_for(r);
    for (int q = ql; q <= qr; ++q) {
      int x;
      cin >> x;
      val[key(q, r)] = x;
    }
  }

  string ops;
  cin >> ops;

  int rot = 0;
  bool mir = false;
  for (char c : ops) {
    if (c == 'R') {
      rot = (rot + 1) % 6;
    } else if (c == 'L') {
      rot = (rot + 5) % 6;
    } else if (c == 'T') {
      mir = !mir;
      rot = (6 - rot) % 6;
    }
  }

  unordered_map<long long, int> moved;
  moved.reserve(val.size());

  for (int r = -k; r <= k; ++r) {
    int ql = q_min_for(r), qr = q_max_for(r);
    for (int q = ql; q <= qr; ++q) {
      int v = val[key(q, r)];
      Cube c = axial_to_cube({q, r});
      if (mir)
        c = mirror_T(c);
      for (int i = 0; i < rot; ++i)
        c = rot_cw(c);
      Axial a2 = cube_to_axial(c);
      moved[key(a2.q, a2.r)] = v;
    }
  }

  for (int r = -k; r <= k; ++r) {
    int ql = q_min_for(r), qr = q_max_for(r);

    int leading_spaces = abs(r);
    for (int i = 0; i < leading_spaces; ++i)
      cout << ' ';

    for (int q = ql; q <= qr; ++q) {
      if (q > ql)
        cout << ' ';
      cout << moved[key(q, r)];
    }
    cout << '\n';
  }

  return 0;
}
