﻿#include <iostream>
#include <vector>
#include <cstdint>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int MOD = 999983;
    const int A = 618023;

    int n;
    int s_input;
    if (!(cin >> n >> s_input)) return 0;

    vector<unsigned char> present(MOD, 0);
    vector<int> elements;
    elements.reserve(200000);

    long long s = s_input;

    for (int step = 0; step < n; ++step) {
        s = (s * (long long)A + 1LL) % MOD;
        int sv = (int)s;

        bool parity = false;

        for (int a : elements) {
            int b = sv - a;
            if (b < 0) continue;
            if (b >= MOD) continue;
            if (b <= a) continue;
            if (present[b]) parity = !parity;
        }

        if (!parity && !present[sv]) {
            present[sv] = 1;
            elements.push_back(sv);
        }
    }

    cout << elements.size() << '\n';
    return 0;
}
