﻿#include <iostream>
#include <vector>
#include <cstdint>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int MOD = 999983;
    const int A = 618023;

    int n;
    int s;
    if (!(cin >> n >> s)) return 0;

    vector<char> present(MOD, 0);

    vector<int> elements;
    elements.reserve(n);

    for (int i = 0; i < n; ++i) {
        s = (int)(((long long)s * A + 1) % MOD);
        bool parity = false;

        int k = elements.size();
        int s_half = s / 2;

        if (k < s_half) {
            for (int a : elements) {
                if (2 * a > s) continue;
                int b = s - a;
                if (present[b]) {
                    parity = !parity;
                }
            }
        }
        else {
            for (int a = 0; a <= s_half; ++a) {
                int b = s - a;
                if (present[a] && present[b]) {
                    parity = !parity;
                }
            }
        }

        if (!parity) {
            if (!present[s]) {
                present[s] = 1;
                elements.push_back(s);
            }
        }
    }

    cout << elements.size() << '\n';
    return 0;
}