def v2(n: int) -> int:
    return (n & -n).bit_length() - 1

def dec_len(n: int) -> int:
    return 1 if n == 0 else (n.bit_length() * 30103) // 100000 + 1

def collatz_next(x: int) -> int:
    return x // 2 if (x & 1) == 0 else 3 * x + 1

def rollout_collatz_cost(x: int, steps: int) -> int:
    cost = 0
    s = steps
    y = x
    while s > 0 and y != 1:
        y = collatz_next(y)
        cost += dec_len(y)
        s -= 1
    return cost

def sample_quantiles(a: int, b: int, m: int):
    n = b - a + 1
    if n <= 0:
        return [a]
    step = n // m
    if step == 0:
        return [a + i for i in range(n)]
    res = []
    for i in range(m):
        mid = a + i * step + step // 2
        if mid < a:
            mid = a
        if mid > b:
            mid = b
        res.append(mid)
    return res

def expected_random_cost(x: int, m: int, horizon: int) -> float:
    a = 3 * x + 1
    b = 6 * x
    ys = sample_quantiles(a, b, m)
    s = 0
    for y in ys:
        s += dec_len(y) + rollout_collatz_cost(y, max(0, horizon - 1))
    return s / len(ys)

def decide_action(x: int, last_random: bool, m: int, horizon: int) -> str:
    if (x & 1) == 0:
        return "collatz"
    k = v2(3 * x + 1)
    d = dec_len(x)
    if k >= 5:
        return "collatz"
    if k == 4 and d < 9:
        return "collatz"
    if last_random or d < 6:
        return "collatz"
    x1 = collatz_next(x)
    coll_cost = dec_len(x1) + rollout_collatz_cost(x1, max(0, horizon - 1))
    rand_cost = expected_random_cost(x, m, horizon)
    risk = 0.5 * d
    return "random" if rand_cost + risk < coll_cost else "collatz"

def main():
    t = int(input())
    for _ in range(t):
        x = int(input())
        last_random = False
        while x != 1:
            action = decide_action(x, last_random, m=6, horizon=20)
            print(action, flush=True)
            x = int(input())
            if x == 0:
                return
            last_random = (action == "random")

if __name__ == "__main__":
    main()
