#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const long long MOD = 1000000007;
const int MAXN = 2000005;

vector<long long> fact(MAXN), inv_fact(MAXN);

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) result = result * base % mod;
        base = base * base % mod;
        exp >>= 1;
    }
    return result;
}

void precompute_factorials(int max_n) {
    fact[0] = 1;
    for (int i = 1; i <= max_n; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    
    inv_fact[max_n] = mod_pow(fact[max_n], MOD - 2, MOD);
    for (int i = max_n - 1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
}

long long mod_comb(int n, int k) {
    if (k > n || k < 0) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    precompute_factorials(MAXN - 1);
    
    int t;
    cin >> t;
    
    while (t--) {
        int p, m;
        cin >> p >> m;
        
        int n = 2 * p + m;
        int max_k = min(n, p + m + 1);
        long long expected = 0;
        
        for (int k = 1; k <= max_k; k++) {
            int k_minus_1 = k - 1;
            
            long long numerator = 0;
            int max_j = min(p, k_minus_1);
            
            for (int j = 0; j <= max_j; j++) {
                int remaining = k_minus_1 - j;
                if (remaining > m) continue;
                
                long long ways = mod_comb(p, j);
                ways = ways * mod_pow(2, j, MOD) % MOD;
                ways = ways * mod_comb(m, remaining) % MOD;
                numerator = (numerator + ways) % MOD;
            }
            
            long long denominator = mod_comb(n, k_minus_1);
            long long prob = numerator * mod_pow(denominator, MOD - 2, MOD) % MOD;
            expected = (expected + prob) % MOD;
        }
        
        cout << expected << "\n";
    }
    
    return 0;
}