#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const long long MOD = 1000000007;
const int MAXN = 2000005;

long long fact[MAXN], inv_fact[MAXN];

long long mod_pow(long long base, long long exp) {
    long long result = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp & 1) result = result * base % MOD;
        base = base * base % MOD;
        exp >>= 1;
    }
    return result;
}

void precompute_factorials() {
    fact[0] = 1;
    for (int i = 1; i < MAXN; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    
    inv_fact[MAXN - 1] = mod_pow(fact[MAXN - 1], MOD - 2);
    for (int i = MAXN - 2; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
}

long long mod_comb(int n, int k) {
    if (k > n || k < 0) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    precompute_factorials();
    
    int t;
    cin >> t;
    
    while (t--) {
        int p, m;
        cin >> p >> m;
        
        int n = 2 * p + m;
        int max_k = min(n, p + m + 1);
        
        vector<long long> ways(max_k + 1, 0);
        
        // Инициализация: только одиночные носки
        for (int k = 0; k <= min(m, max_k); k++) {
            ways[k] = mod_comb(m, k);
        }
        
        // ДП: добавляем пары по одной
        for (int i = 0; i < p; i++) {
            // Оптимизация: обновляем только до реально достижимого k
            int limit = min(max_k, i + m + 1);
            for (int k = limit; k >= 1; k--) {
                ways[k] = (ways[k] + 2 * ways[k - 1]) % MOD;
            }
        }
        
        // Вычисляем математическое ожидание
        long long expected = 0;
        for (int k = 1; k <= max_k; k++) {
            long long numerator = ways[k - 1];
            if (numerator == 0) continue;
            
            long long denominator = mod_comb(n, k - 1);
            if (denominator == 0) break;
            
            long long prob = numerator * mod_pow(denominator, MOD - 2) % MOD;
            expected = (expected + prob) % MOD;
        }
        
        cout << expected << "\n";
    }
    
    return 0;
}
