#include <iostream>
#include <vector>
#include <numeric>
using namespace std;

int calculateWinner(const vector<long long>& arr, int n) {
    long long seed = 0;
    for (int i = 0; i < n; i++) {
        seed = (seed * 31 + arr[i]) % n;
    }
    return seed + 1;
}

long long findMissingNumber(const vector<long long>& arr, int n) {
    long long sum = accumulate(arr.begin(), arr.end(), 0LL);
    long long total = (long long)(n + 1) * (n + 2) / 2;
    return total - sum;
}

int computeResult(int pos, int n, long long missing) {
    int size = n + 1;
    long long res = ((pos - 1) * size + missing) % size;
    return (res == 0) ? size : res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long long cmd;
    if (!(cin >> cmd)) return 0;

    int n;
    cin >> n;

    vector<long long> nums(n);
    for (int i = 0; i < n; i++) {
        cin >> nums[i];
    }

    if (cmd == 0) {
        cout << calculateWinner(nums, n) << '\n';
    } else {
        long long missing = findMissingNumber(nums, n);
        cout << computeResult(cmd, n, missing) << '\n';
    }
    
    return 0;
}