#include <iostream>
#include <unordered_set>
#include <bitset>
#include <vector>

using namespace std;

const int MOD = 999983;
const int MAX_SUM = 2 * MOD;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n, s;
    cin >> n >> s;
    unordered_set<int> V;
    bitset<MAX_SUM> parity;
    vector<int> elements;
    elements.reserve(n);

    for (int i = 0; i < n; i++) {
        s = (1LL * s * 618023 + 1) % MOD;

        if (!parity[s]) {
            for (int x : elements) {
                int sum = s + x;
                parity.flip(sum);
            }
            elements.push_back(s);
            V.insert(s);
        }
    }
    cout << V.size() << endl;

    return 0;
}
