#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

typedef long long ll;

struct Point {
    ll x, y;
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

ll cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convex_hull(vector<Point> P) {
    int n = P.size();
    if (n <= 1) return P;
    sort(P.begin(), P.end());
    P.erase(unique(P.begin(), P.end()), P.end());
    n = P.size();

    vector<Point> hull;
    for (int i = 0; i < n; ++i) {
        while (hull.size() >= 2 && cross(hull[hull.size() - 2], hull.back(), P[i]) <= 0)
            hull.pop_back();
        hull.push_back(P[i]);
    }

    int lower_len = hull.size();
    for (int i = n - 2; i >= 0; --i) {
        while ((int)hull.size() > lower_len && cross(hull[hull.size() - 2], hull.back(), P[i]) <= 0)
            hull.pop_back();
        hull.push_back(P[i]);
    }

    if (hull.size() > 1) hull.pop_back();
    return hull;
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0);

    int n; cin >> n;
    vector<Point> pts(n);
    for (int i = 0; i < n; ++i) cin >> pts[i].x >> pts[i].y;

    if (n == 1) {
        cout << "1 0 " << -pts[0].x << "\n1 0 " << -pts[0].x;
        return 0;
    }

    auto hull = convex_hull(pts);
    int h = hull.size();

    if (h == 1) {
        cout << "1 0 " << -hull[0].x << "\n1 0 " << -hull[0].x;
        return 0;
    }
    if (h == 2) {
        ll a = hull[1].x - hull[0].x;
        ll b = hull[1].y - hull[0].y;
        ll c1 = -a * hull[0].x - b * hull[0].y;
        ll c2 = -a * hull[1].x - b * hull[1].y;
        cout << a << ' ' << b << ' ' << c1 << '\n' << a << ' ' << b << ' ' << c2;
        return 0;
    }


    int k = 1;
    ll best = 0;
    int best_i = 0, best_j = 0;

    for (int i = 0; i < h; ++i) {
        while (true) {
            ll current = (hull[(i + 1) % h].x - hull[i].x) * (hull[k].y - hull[i].y) - (hull[(i + 1) % h].y - hull[i].y) * (hull[k].x - hull[i].x);
            ll next = (hull[(i + 1) % h].x - hull[i].x) * (hull[(k + 1) % h].y - hull[i].y) - (hull[(i + 1) % h].y - hull[i].y) * (hull[(k + 1) % h].x - hull[i].x);
            if (next > current) {
                k = (k + 1) % h;
            }
            else {
                break;
            }
        }

        ll dx = hull[i].x - hull[k].x;
        ll dy = hull[i].y - hull[k].y;
        ll dist2 = dx * dx + dy * dy;
        if (dist2 > best) {
            best = dist2;
            best_i = i;
            best_j = k;
        }
    }

    Point A = hull[best_i], B = hull[best_j];
    ll a = B.x - A.x;
    ll b = B.y - A.y;


    ll minF = a * hull[0].x + b * hull[0].y;
    ll maxF = minF;
    for (int i = 1; i < h; ++i) {
        ll f = a * hull[i].x + b * hull[i].y;
        if (f < minF) minF = f;
        if (f > maxF) maxF = f;
    }

    cout << a << ' ' << b << ' ' << -minF << '\n';
    cout << a << ' ' << b << ' ' << -maxF << '\n';
    return 0;
}