#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

typedef long long ll;

struct Point {
    ll x, y;
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
    bool operator==(const Point& p) const {
        return x == p.x && y == p.y;
    }
};

ll cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convex_hull(vector<Point> pts) {
    if (pts.size() <= 1) return pts;
    sort(pts.begin(), pts.end());
    pts.erase(unique(pts.begin(), pts.end()), pts.end());

    vector<Point> hull;
    for (int i = 0; i < (int)pts.size(); ++i) {
        while (hull.size() >= 2 && cross(hull[hull.size() - 2], hull.back(), pts[i]) <= 0)
            hull.pop_back();
        hull.push_back(pts[i]);
    }

    int lower_len = hull.size();
    for (int i = (int)pts.size() - 2; i >= 0; --i) {
        while ((int)hull.size() > lower_len && cross(hull[hull.size() - 2], hull.back(), pts[i]) <= 0)
            hull.pop_back();
        hull.push_back(pts[i]);
    }

    if (hull.size() > 1) hull.pop_back();
    return hull;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;
    vector<Point> all(n);
    for (int i = 0; i < n; ++i) {
        cin >> all[i].x >> all[i].y;
    }

    if (n == 1) {
        cout << "1 0 " << -all[0].x << "\n1 0 " << -all[0].x << "\n";
        return 0;
    }

    auto hull = convex_hull(all);
    int h = hull.size();


    if (h == 1) {
        cout << "1 0 " << -hull[0].x << "\n1 0 " << -hull[0].x << "\n";
        return 0;
    }

    ll best_width = -1;
    ll best_a = 1, best_b = 0, best_c1 = 0, best_c2 = 0;


    for (int i = 0; i < h; ++i) {
        for (int j = 0; j < h; ++j) {
            if (i == j) continue;
            ll a = hull[j].x - hull[i].x;
            ll b = hull[j].y - hull[i].y;

            ll min_f = a * hull[0].x + b * hull[0].y;
            ll max_f = min_f;
            for (int k = 1; k < h; ++k) {
                ll f = a * hull[k].x + b * hull[k].y;
                if (f < min_f) min_f = f;
                if (f > max_f) max_f = f;
            }

            ll width = max_f - min_f;
            if (width > best_width) {
                best_width = width;
                best_a = a;
                best_b = b;
                best_c1 = -min_f;
                best_c2 = -max_f;
            }
        }
    }


    ll min_all = best_a * all[0].x + best_b * all[0].y;
    ll max_all = min_all;
    for (int i = 1; i < n; ++i) {
        ll f = best_a * all[i].x + best_b * all[i].y;
        if (f < min_all) min_all = f;
        if (f > max_all) max_all = f;
    }

    cout << best_a << " " << best_b << " " << -min_all << "\n";
    cout << best_a << " " << best_b << " " << -max_all << "\n";

    return 0;
}