#include <iostream>
#include <vector>
#include <cstdint>

using namespace std;

static const int M = 999983;
static const int W = (M + 63) / 64;

inline bool get_bit(const vector<uint64_t>& a, int idx) {
    return (a[idx >> 6] >> (idx & 63)) & 1ULL;
}
inline void flip_bit(vector<uint64_t>& a, int idx) {
    a[idx >> 6] ^= (1ULL << (idx & 63));
}
inline void set_bit(vector<uint64_t>& a, int idx) {
    a[idx >> 6] |= (1ULL << (idx & 63));
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    int s;
    if (!(cin >> n >> s)) return 0;

    vector<uint64_t> A(W, 0), P(W, 0);

    auto advance_s = [](int s0) -> int {
        const int Acoef = 618023;
        long long v = ((long long)s0 * Acoef + 1) % M;
        return (int)v;
        };

    int sizeV = 0;

    for (int step = 0; step < n; ++step) {
        s = advance_s(s);

        bool even = ((P[s >> 6] >> (s & 63)) & 1ULL) == 0;

        if (even && !get_bit(A, s)) {
            int shift_bits = s & 63;
            int shift_words = s >> 6;

            int limit = M - s;
            int words_y = (limit + 63) / 64;

            uint64_t carry = 0;
            for (int w = 0; w < words_y; ++w) {
                uint64_t v = A[w];

                if (w == words_y - 1) {
                    int rem = limit - (w << 6);
                    if (rem < 64) {
                        uint64_t mask = (rem == 64 ? ~0ULL : ((1ULL << rem) - 1));
                        v &= mask;
                    }
                }

                uint64_t lo = (shift_bits == 0) ? v : (v << shift_bits);
                uint64_t hi = (shift_bits == 0) ? 0 : (v >> (64 - shift_bits));

                P[shift_words + w] ^= lo;
                if (hi && shift_words + w + 1 < W) P[shift_words + w + 1] ^= hi;
            }

            if (2 * s < M) flip_bit(P, 2 * s);

            set_bit(A, s);
            ++sizeV;
        }
    }

    cout << sizeV << '\n';
    return 0;
}
