#include <bits/stdc++.h>
using namespace std;
using int64 = long long;

const int64 MOD = 1'000'000'007;

int64 modpow(int64 a, int64 e) {
    int64 r = 1;
    while (e) {
        if (e & 1) r = r * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return r;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    vector<pair<int,int>> qs(T);
    int maxP = 0, maxM = 0;
    for (int i = 0; i < T; ++i) {
        cin >> qs[i].first >> qs[i].second;
        maxP = max(maxP, qs[i].first);
        maxM = max(maxM, qs[i].second);
    }

    int maxN = 2 * maxP + maxM;
    vector<int64> fact(maxN + 1), invfact(maxN + 1);
    fact[0] = 1;
    for (int i = 1; i <= maxN; ++i) fact[i] = fact[i-1] * i % MOD;
    invfact[maxN] = modpow(fact[maxN], MOD - 2);
    for (int i = maxN; i >= 1; --i) invfact[i-1] = invfact[i] * i % MOD;

    for (auto [p, m] : qs) {
        int N = 2 * p + m;
        int64 invFactN = invfact[N];

        vector<int64> S(p + m + 1);
        vector<int64> Cp(p + 1), Cm(m + 1);
        Cp[0] = 1; Cm[0] = 1;
        for (int i = 1; i <= p; ++i)
            Cp[i] = Cp[i-1] * (p - i + 1) % MOD * modpow(i, MOD-2) % MOD;
        for (int j = 1; j <= m; ++j)
            Cm[j] = Cm[j-1] * (m - j + 1) % MOD * modpow(j, MOD-2) % MOD;

        int64 pow2 = 1;
        for (int t = 0; t <= p + m; ++t) {
            int start = max(0, t - m);
            int end = min(p, t);
            int64 sum = 0;
            pow2 = 1;
            for (int i = start; i <= end; ++i) {
                int j = t - i;
                sum = (sum + Cp[i] * Cm[j] % MOD * modpow(2, i) % MOD) % MOD;
            }
            S[t] = sum;
        }

        int64 ans = 0;
        for (int t = 0; t <= p + m; ++t) {
            if (t > N) break;
            int64 term = fact[t] * S[t] % MOD * fact[N - t] % MOD;
            ans = (ans + term) % MOD;
        }

        ans = ans * invFactN % MOD;
        cout << ans << "\n";
    }
    return 0;
}
