#include <bits/stdc++.h>

using namespace std;

#ifdef DEBUG
#define DEB 1
#else
#define DEB 0
#define cerr \
  if (DEB)   \
  cerr
#endif
#define MTEST() \
  int _t;       \
  cin >> _t;    \
  for (int _tn = 0; _tn < _t; ++_tn)
#define ALL(c) c.begin(), c.end()
#define SZ(c) (int)c.size()

typedef long long ll;

void run_solve();

signed main() {
#if DEB
  assert(freopen("test.in", "r", stdin));
  assert(freopen("test.out", "w", stdout));
#endif
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);
  cerr.precision(3);
  cerr << fixed;
  int start = (int)clock();
  run_solve();
  double run_time = (double)(clock() - start) / CLOCKS_PER_SEC;
  cerr << "TIME: " << run_time << '\n';
  return 0;
}

#define int ll

struct Point {
  int x, y;
};

istream& operator>>(istream& in, Point& A) {
  return in >> A.x >> A.y;
}

ostream& operator<<(ostream& out, Point A) {
  return out << A.x << ' ' << A.y;
}

bool operator!=(Point A, Point B) {
  return tie(A.x, A.y) != tie(B.x, B.y);
}

int dist(Point A, Point B) {
  return (A.x - B.x) * (A.x - B.x) + (A.y - B.y) * (A.y - B.y);
}

struct Line {
  int a, b, c;

  Line() {}

  Line(Point A, Point B) {
    a = A.y - B.y;
    b = B.x - A.x;
    c = -(a * A.x + b * A.y);
  }

  Line(Line p, Point A) {
    a = p.a;
    b = p.b;
    c = p.c - p(A);
  }

  int operator()(Point A) { return a * A.x + b * A.y + c; }
};

ostream& operator<<(ostream& out, Line n) {
  return out << n.a << ' ' << n.b << ' ' << n.c;
}

const int N = 1007;

int n;
Point p[N];

bool check(Line q) {
  int sign = 0;
  for (int i = 0; i < n; ++i) {
    int cur = q(p[i]);
    if (cur == 0) {
      continue;
    } else if (cur < 0) {
      if (sign > 0) {
        return false;
      }
      sign = -1;
    } else {
      if (sign < 0) {
        return false;
      }
      sign = +1;
    }
  }
  return true;
}

void run_solve() {
  cin >> n;
  for (int i = 0; i < n; ++i) {
    cin >> p[i];
  }
  Point A = p[0], B = p[0];
  for (int i = 0; i < n; ++i) {
    for (int j = 0; j < n; ++j) {
      if (dist(A, B) < dist(p[i], p[j])) {
        A = p[i];
        B = p[j];
      }
    }
  }
  Point C = A;
  C.x -= (B.y - A.y);
  C.y += (B.x - A.x);
  Line q(A, C);
  Line w(q, B);
  cout << q << '\n' << w << '\n';
  // for (int i = 0; i < n; ++i) {
  //   if (A != p[i]) {
  //     Line q(A, p[i]);
  //     Line w(q, B);
  //     if (q(B) != 0 && check(q) && check(w)) {
  //       cout << q << '\n' << w << '\n';
  //       return;
  //     }
  //   }
  //   if (B != p[i]) {
  //     Line q(B, p[i]);
  //     Line w(q, A);
  //     if (q(A) != 0 && check(q) && check(w)) {
  //       cout << q << '\n' << w << '\n';
  //     }
  //   }
  // }
  // if (A.y != B.y) {
  //   Point C = A;
  //   ++C.x;
  //   Line q(A, C);
  //   Line w(q, B);
  //   cout << q << '\n' << w << '\n';
  // } else if (A.x != B.x) {
  //   Point C = A;
  //   ++C.y;
  //   Line q(A, C);
  //   Line w(q, B);
  //   cout << q << '\n' << w << '\n';
  // } else {
  //   assert(false);
  // }
}