#include <iostream>
#include <vector>
#include <string>
#include <cmath>

using namespace std;

vector<int> getMapping(char note) {
    switch(note) {
        case 'A': return {0, 7, 14, 21, 28, 35, 42, 49};
        case 'B': return {1, 8, 15, 22, 29, 36, 43, 50};
        case 'C': return {2, 9, 16, 23, 30, 37, 44, 51};
        case 'D': return {3, 10, 17, 24, 31, 38, 45};
        case 'E': return {4, 11, 18, 25, 32, 39, 46};
        case 'F': return {5, 12, 19, 26, 33, 40, 47};
        case 'G': return {6, 13, 20, 27, 34, 41, 48};
        default: return {};
    }
}

int main() {
    int t;
    cin >> t;
    while (t--) {
        string s;
        cin >> s;
        int n = s.size();
        vector<vector<int>> options(n);
        for (int i = 0; i < n; i++) {
            options[i] = getMapping(s[i]);
        }
        
        vector<vector<bool>> dp(n);
        dp[0].resize(options[0].size(), true);
        
        for (int i = 1; i < n; i++) {
            int m_cur = options[i].size();
            int m_prev = options[i-1].size();
            dp[i].resize(m_cur, false);
            for (int j = 0; j < m_cur; j++) {
                int cur_abs = options[i][j];
                for (int k = 0; k < m_prev; k++) {
                    if (dp[i-1][k] && abs(cur_abs - options[i-1][k]) <= 3) {
                        dp[i][j] = true;
                        break;
                    }
                }
            }
        }
        
        bool found = false;
        for (bool val : dp[n-1]) {
            if (val) {
                found = true;
                break;
            }
        }
        cout << (found ? "Yes" : "No") << endl;
    }
    return 0;
}
