import sys
import math


def solve():
    data = sys.stdin.read().strip().split()
    coords = list(map(int, data))

    x1, y1, x2, y2, x3, y3, x4, y4 = coords

    d1 = math.hypot(x2 - x1, y2 - y1)
    d2 = math.hypot(x3 - x2, y3 - y2)

    length = max(d1, d2)
    width = min(d1, d2)

    area = math.pi * length * width / 4

    print(f"{area:.8f}")


if __name__ == "__main__":
    solve()