import sys

def minimal_rotation(s):
    n = len(s)
    if n == 0:
        return 0
    i = 0
    j = 1
    k = 0
    while i < n and j < n and k < n:
        a = s[(i + k) % n]
        b = s[(j + k) % n]
        if a == b:
            k += 1
            continue
        if a > b:
            i = i + k + 1
            if i <= j:
                i = j + 1
        else:
            j = j + k + 1
            if j <= i:
                j = i + 1
        k = 0
    idx = min(i, j)
    return idx % n

def read_ints():
    data = sys.stdin.read().strip().split()
    if not data:
        return []
    return list(map(int, data))

def first_run(n, arr):
    idx = minimal_rotation(arr)
    print(idx + 1)

def second_run(chosen_player, n_visible, visible):
    n = n_visible + 1
    i = chosen_player - 1

    def make_full(x):
        full = [0]*n
        full[i] = x
        cnt1 = n - i - 1
        for t in range(cnt1):
            full[i+1 + t] = visible[t]
        for t in range(n - 1 - cnt1):
            full[t] = visible[cnt1 + t]
        return full

    answer = None
    for x in range(1, n+1):
        full = make_full(x)
        if minimal_rotation(full) == i:
            answer = x
            break
    if answer is None:
        answer = 1
    print(answer)

def main():
    data = read_ints()
    if not data:
        return
    ptr = 0
    first = data[ptr]; ptr += 1
    if first == 0:
        if ptr >= len(data):
            return
        n = data[ptr]; ptr += 1
        arr = data[ptr:ptr+n]
        first_run(n, arr)
    else:
        chosen_player = first
        if ptr >= len(data):
            return
        n_visible = data[ptr]; ptr += 1
        visible = data[ptr:ptr + n_visible]
        second_run(chosen_player, n_visible, visible)

if __name__ == "__main__":
    main()
