note_to_positions = {
    'A': [0, 7, 14, 21, 28, 35, 42, 49],
    'B': [1, 8, 15, 22, 29, 36, 43, 50],
    'C': [2, 9, 16, 23, 30, 37, 44, 51],
    'D': [3, 10, 17, 24, 31, 38, 45],
    'E': [4, 11, 18, 25, 32, 39, 46],
    'F': [5, 12, 19, 26, 33, 40, 47],
    'G': [6, 13, 20, 27, 34, 41, 48]
}

t = int(input())
melodies = [input().strip() for _ in range(t)]

for melody in melodies:
    possible_keys = set(note_to_positions[melody[0]])
    can_play = True

    for note in melody[1:]:
        next_keys = set()
        for prev_key in possible_keys:
            for key_pos in note_to_positions[note]:
                if abs(key_pos - prev_key) <= 3:
                    next_keys.add(key_pos)
        if not next_keys:
            can_play = False
            break
        possible_keys = next_keys

    print("Yes" if can_play else "No")
