#include <iostream>
#include <unordered_map>
#include <vector>
#include <set>
using namespace std;

bool can_play(unordered_map<string, vector<int>>& note_pos, string& s);

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t; cin >> t;
    vector<string> strs;
    for (int i = 0; i < t; ++i) {
        string s; cin >> s;
        strs.push_back(s);
    }

    unordered_map<string, vector<int>> note_pos = {
        {"A", vector<int>{0, 7, 14, 21, 28, 35, 42, 49}},
        {"B", vector<int>{1, 8, 15, 22, 29, 36, 43, 50}},
        {"C", vector<int>{2, 9, 16, 23, 30, 37, 44, 51}},
        {"D", vector<int>{3, 10, 17, 24, 31, 38, 45}},
        {"E", vector<int>{4, 11, 18, 25, 32, 39, 46}},
        {"F", vector<int>{5, 12, 19, 26, 33, 40, 47}},
        {"G", vector<int>{6, 13, 20, 27, 34, 41, 48}},
    };

    for (auto& s : strs) {
        if (can_play(note_pos, s))
            cout << "YES\n";
        else
            cout << "NO\n";
    }

    return 0;
}

bool can_play(unordered_map<string, vector<int>>& note_pos, string& s) {
    int n = s.size();
    set<int> dp;
    string first_note(1, s[0]);
    for (int pos : note_pos.at(first_note))
        dp.insert(pos);

    for (int i = 1; i < n; ++i) {
        set<int> next_dp;
        string curr_note(1, s[i]);
        for (int j : note_pos.at(curr_note)) {
            for (int k : dp) {
                if (abs(j - k) <= 3) {
                    next_dp.insert(j);
                    break;
                }
            }
        }
        dp = move(next_dp);
        if (dp.empty())
            return false;
    }
    return true;
}
