#include <iostream>
using namespace std;
#include <vector>
#include <algorithm>
#include <sstream>


struct sloi {
    vector<int> a;
    int start_pointer;
    bool reversed;
};

void printGrid(int n, const vector<vector<int>>& grid) {
    for (int i = 0; i < 2 * n - 1; ++i) {
        int elemInRow = grid[i].size();
        int widest_row_elements = 2 * n - 1;
        int padding = (widest_row_elements - elemInRow);
        cout << string(padding, ' ');
        for (int j = 0; j < elemInRow; ++j)
            cout << grid[i][j] << (j == elemInRow - 1 ? "" : " ");
        cout << endl;
    }
}


string simplify(string input) {
    bool mirrored = false;
    int rotation = 0; 

    for (char op : input) {
        if (op == 'T')
            mirrored = !mirrored;
        else if (op == 'R') {
            if (mirrored)
                rotation = (rotation + 5) % 6;
            else
                rotation = (rotation + 1) % 6;
        } 
        else if (op == 'L') {
            if (mirrored)
                rotation = (rotation + 1) % 6;
            else
                rotation = (rotation + 5) % 6;
        }
    }

    string result = "";
    if (mirrored) result += 'T';
    if (rotation == 1) result += 'R';
    else if (rotation == 2) result += "RR";
    else if (rotation == 3) result += "LLL";
    else if (rotation == 4) result += "LL";
    else if (rotation == 5) result += 'L';
    return result;
}

int main() {
    int n; cin >> n;
    string line; getline(cin, line);

    vector<vector<int>> grid(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; ++i) {
        getline(cin, line);
        stringstream ss(line);
        int num;
        while (ss >> num)
            grid[i].push_back(num);
    }

    string operations;
    cin >> operations;

    vector<sloi> layers;
    for (int i = 0; i < n; ++i) {
        sloi current_sloi;
        current_sloi.start_pointer = 0;
        current_sloi.reversed = false;
        
        int size = n - i;
        if (size == 1) {
            current_sloi.a.push_back(grid[n - 1][n - 1]);
            layers.push_back(current_sloi);
            continue;
        }

        vector<int> layerValues;
        int r_start = i;
        int r_end = 2 * n - 2 - i;
        int mid_row = n - 1;

        for (int j = i; j < i + size; ++j) 
            layerValues.push_back(grid[r_start][j]);
        for (int r = r_start + 1; r <= mid_row; ++r) 
            layerValues.push_back(grid[r][grid[r].size() - 1 - i]);
        for (int r = mid_row + 1; r <= r_end; ++r) 
            layerValues.push_back(grid[r][grid[r].size() - 1 - i]);
        for (int j = i + size - 2; j >= i; --j) 
            layerValues.push_back(grid[r_end][j]);
        for (int r = r_end - 1; r >= mid_row; --r) 
            layerValues.push_back(grid[r][i]);
        for (int r = mid_row - 1; r > r_start; --r) 
            layerValues.push_back(grid[r][i]);
        
        int top_edge_len = size;
        int start_idx = (top_edge_len % 2 != 0) ? top_edge_len / 2 : 0;

        for(int k=0; k < layerValues.size(); ++k)
            current_sloi.a.push_back(layerValues[(start_idx + k) % layerValues.size()]);
        layers.push_back(current_sloi);
    }

    for (const auto& layer : layers) {
        vector<int> temp;
        int len = layer.a.size();
        if (len == 0) continue;

        if (!layer.reversed) {
            for (int i = 0; i < len; ++i) {
                temp.push_back(layer.a[(layer.start_pointer + i) % len]);
            }
        } 
        else {
            for (int i = 0; i < len; ++i) {
                temp.push_back(layer.a[(layer.start_pointer - i + len) % len]);
            }
        }
    }

    for (int i = 0; i < operations.size(); ++i) {
        char sim = operations[i];
        if (sim == 'T') {
            int j = 0;
            for (auto &layer : layers) {
                int len = layer.a.size();
                layer.reversed = !layer.reversed;
                layer.start_pointer = (layer.start_pointer + j%2) % len;
                j++;
            }
        } 
        if (sim == 'L') {
            for (auto &layer : layers) {
                int len = layer.a.size();
                if (len > 0) {
                    int shift = len / 6;
                    layer.start_pointer = (layer.start_pointer + shift + len) % len;
                }
            }
        }
        if (sim == 'R') {
            for (auto &layer : layers) {
                int len = layer.a.size();
                 if (len > 0) {
                    int shift = len / 6;
                    layer.start_pointer = (layer.start_pointer - shift + len) % len;
                }
            }
        }
    }

    vector<vector<int>> final_grid = grid;

    for (int i = 0; i < n; ++i) {
        const auto& layer = layers[i];
        vector<int> temp;
        int len = layer.a.size();
        if (len == 0) continue;

        if (!layer.reversed) {
            for (int k = 0; k < len; ++k) {
                temp.push_back(layer.a[(layer.start_pointer + k) % len]);
            }
        } else {
            for (int k = 0; k < len; ++k) {
                temp.push_back(layer.a[(layer.start_pointer - k + len) % len]);
            }
        }

        int size = n - i;
        int top_edge_len = size;
        int start_idx_offset = (top_edge_len % 2 != 0) ? top_edge_len / 2 : 0;
        
        vector<int> final_layer_values(len);
        for(int k=0; k < len; ++k) {
            final_layer_values[(start_idx_offset + k) % len] = temp[k];
        }

        if (size == 1) {
            final_grid[n - 1][n - 1] = final_layer_values[0];
            continue;
        }

        int r_start = i;
        int r_end = 2 * n - 2 - i;
        int mid_row = n - 1;
        int current_val_idx = 0;

        for (int j = i; j < i + size; ++j) 
            final_grid[r_start][j] = final_layer_values[current_val_idx++];
        for (int r = r_start + 1; r <= mid_row; ++r) 
            final_grid[r][final_grid[r].size() - 1 - i] = final_layer_values[current_val_idx++];
        for (int r = mid_row + 1; r <= r_end; ++r) 
            final_grid[r][final_grid[r].size() - 1 - i] = final_layer_values[current_val_idx++];
        for (int j = i + size - 2; j >= i; --j) 
            final_grid[r_end][j] = final_layer_values[current_val_idx++];
        for (int r = r_end - 1; r >= mid_row; --r) 
            final_grid[r][i] = final_layer_values[current_val_idx++];
        for (int r = mid_row - 1; r > r_start; --r) 
            final_grid[r][i] = final_layer_values[current_val_idx++];
    }
    printGrid(n, final_grid);
    
    return 0;
}