#include <iostream>
#include <vector>
#include <cstdint>

using namespace std;

const int M = 999983;
const int HI = M - 1;

inline int popc(uint64_t x) {
#ifdef _MSC_VER
    return (int)__popcnt64(x);
#else
    return __builtin_popcountll(x);
#endif
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    long long s;
    cin >> n >> s;

    const int W = (M + 63) / 64;
    vector<uint64_t> B(W), R(W);

    auto setbit = [&](vector<uint64_t>& v, int p) {
        v[p >> 6] |= 1ULL << (p & 63);
        };
    auto getbit = [&](const vector<uint64_t>& v, int p) -> int {
        return (v[p >> 6] >> (p & 63)) & 1;
        };

    for (int i = 0; i < n; i++) {
        s = (s * 618023 + 1) % M;
        int sh = HI - (int)s;
        long long C = 0;

        if (sh >= 0) {
            int w = sh >> 6, b = sh & 63;
            for (int j = 0; j + w < W; j++) {
                uint64_t x = R[j + w] >> b;
                if (b && j + w + 1 < W)
                    x |= R[j + w + 1] << (64 - b);
                C += popc(B[j] & x);
            }
        }
        else {
            int L = -sh, w = L >> 6, b = L & 63;
            for (int j = w; j < W; j++) {
                uint64_t x = R[j - w] << b;
                if (b && j - w - 1 >= 0)
                    x |= R[j - w - 1] >> (64 - b);
                C += popc(B[j] & x);
            }
        }

        int E = 0;
        if (((int)s & 1) == 0) E = getbit(B, (int)s >> 1);
        int k_mod4 = (int)((C - E) & 3);
        int half_par = (k_mod4 >= 2);
        int U_par = half_par ^ (E & 1);

        if (U_par == 0) {
            setbit(B, (int)s);
            setbit(R, HI - (int)s);
        }
    }

    long long ans = 0;
    for (auto x : B) ans += popc(x);
    cout << ans << '\n';
    return 0;
}
