def solve():
    n = int(input().strip())

    hex_grid = []
    for i in range(2 * n - 1):
        line = input().strip()
        numbers = list(map(int, line.split()))
        hex_grid.append(numbers)

    operations = input().strip()

    state = 0
    reflect = False

    for op in operations:
        if op == 'T':
            reflect = not reflect
        elif op == 'R':
            state = (state + 1) % 6
        elif op == 'L':
            state = (state - 1) % 6

    def transform_coords(i, j, state, reflect, n):
        total_rows = 2 * n - 1

        if state == 0 and not reflect:
            return i, j

        return i, j

    new_hex = [[0] * len(hex_grid[i]) for i in range(len(hex_grid))]

    for i in range(len(hex_grid)):
        for j in range(len(hex_grid[i])):
            new_i, new_j = transform_coords(i, j, state, reflect, n)
            new_hex[new_i][new_j] = hex_grid[i][j]


    for row in new_hex:
        print(' '.join(map(str, row)))


if __name__ == "__main__":
    solve()