#include <bits/stdc++.h>
using namespace std;
#define int long long
using ld = long double;

struct point {
    ld x, y;

    explicit point(ld x = 0, ld y = 0) : x(x), y(y) {
    }

    point(point a, point b) {
        x = b.x - a.x;
        y = b.y - a.y;
    }

    point operator+(point p) const {
        return point(x + p.x, y + p.y);
    }

    point operator-(point p) const {
        return point(x - p.x, y - p.y);
    }

    point operator*(ld k) const {
        return point(x * k, y * k);
    }

    ld len() const {
        return sqrt(x * x + y * y);
    }

    ld operator*(point p) const {
        return x * p.x + y * p.y;
    }

    ld operator%(point p) const {
        return x * p.y - y * p.x;
    }
};

istream& operator>>(istream& is, point& p) {
    is >> p.x >> p.y;
    return is;
}

ostream& operator<<(ostream& os, const point& p) {
    os << (int) p.x << ' ' << (int) p.y;
    return os;
}

ld angle(point a, point b) {
    return atan2(a % b, a * b);
}

///Проверка на пересечение отрезков
bool check(point a, point b, point c, point d) {
    if ((point(a, b) % point(a, c)) * (point(a, b) % point(a, d)) <= 0 &&
        (point(c, d) % point(c, a)) * (point(c, d) % point(c, b)) <= 0) {
        ld x1, x2, y1, y2;
        x1 = max(min(a.x, b.x), min(c.x, d.x)), x2 = min(max(a.x, b.x), max(c.x, d.x));
        y1 = max(min(a.y, b.y), min(c.y, d.y)), y2 = min(max(a.y, b.y), max(c.y, d.y));
        return (x1 <= x2) && (y1 <= y2);
        }
    return false;
}

///От точки до точки
ld dist(point a, point b) {
    return point(a, b).len();
}

ld f(point norm, point p) {
    long long a, b, c;
    point p1 = p;
    point p2 = p + norm;
    a = p2.y - p1.y, b = p1.x - p2.x, c = -1 * (a * p1.x + b * p1.y);
    cout << a << ' ' << b << ' ' << c << '\n';
    return 0.0;
}

signed main() {
    // Queen of Wands
    // Knight of Swords
    // The Fool
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<point> v(n);
    for (int i = 0; i < n; ++i) {
        cin >> v[i];
    }
    point mxa, mxb;
    ld mx = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            if (mx < dist(v[i], v[j])) {
                mx = dist(v[i], v[j]);
                mxa = v[i];
                mxb = v[j];
            }
        }
    }
    point p1 = mxb - mxa;
    point normal1 = point(p1.y, -p1.x);
    f(normal1, mxa);
    f(normal1, mxb);
    //long long a, b, c;
    //a = normal1.y - p1.y, b = normal1.x - mxb.x, c = -1 * (a * normal1.x + b * normal1.y);
    //cout << a << ' ' << b << ' ' << c << '\n';
    //cout << a << ' ' << b << ' ' << c + p1.len() << '\n';
    // int type;
    // cin >> type;
    // if (type == 0) {
    //     int n;
    //     cin >> n;
    //     vector<bool> used(n);
    //     vector<int> v(n);
    //     int cnt = 0;
    //     for (int i = 0; i < n; ++i) {
    //         cin >> v[i];
    //         if (used[v[i] - 1] == false) {
    //             cnt++;
    //         }
    //         used[v[i] - 1] = true;
    //     }
    //     if (cnt == n) {
    //         bool fnd = false;
    //         for (int i = 0; i < n - 1; ++i) {
    //             if (v[i + 1] == 1) {
    //                 fnd = true;
    //                 cout << i + 1 << endl;
    //                 break;
    //             }
    //         }
    //         if (!fnd) {
    //             cout << n << endl;
    //         }
    //     } else {
    //
    //     }
    // }
}