#include <iostream>
#include <cstdint>

#define int long long

int MOD = 1000000000 + 7;

int factorial(int n) {
    int res = 1;
    for (int i = 2; i <= n; i++) {
        res *= i;
        res %= MOD;
    }
    return res;
}

int mod_pow(int base) {
    int result = 1;
    int exp = MOD - 2;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1)
            result = (result * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return result;
}

int32_t main() {
    int t, p, m;
    std::cin >> t;
    while (t--) {
        std::cin >> p >> m;
        int res = 0;
        int count = 0;
        for (int k = 2; k <= p + m + 1; ++k) {
            int a = (1/p) * (k - 1) * factorial(p + m - 1) / factorial(p + m - 1 - k + 2);
            res += k * a;
            count += a;
        }
        count = count % MOD;
        res = res % MOD;
        std::cout << (res * mod_pow(count)) % MOD << std::endl;
    }
}
