#include <iostream>
#include <vector>
#include <map>
#include <string>
#include <algorithm>

using namespace std;

map<pair<long long, long long>, long long> to_coords(const vector<vector<long long>>& a) {
    map<pair<long long, long long>, long long> coords;
    long long n = a.size();
    long long mid = n / 2;

    for (long long i = 0; i < n; i++) {
        long long start = -mid + max(0, mid - i);
        for (long long j = 0; j < a[i].size(); j++) {
            long long q = start + j;
            long long r = i - mid;
            coords[{q, r}] = a[i][j];
        }
    }
    return coords;
}

vector<vector<long long>> to_sota(const map<pair<long long, long long>, long long>& coords) {
    vector<long long> rs;
    for (const auto& entry : coords) {
        rs.push_back(entry.first.second);
    }

    if (rs.empty()) {
        return {};
    }

    long long min_r = *min_element(rs.begin(), rs.end());
    long long max_r = *max_element(rs.begin(), rs.end());

    vector<vector<long long>> result;
    for (long long r = min_r; r <= max_r; r++) {
        vector<pair<long long, long long>> row_entries;
        for (const auto& entry : coords) {
            if (entry.first.second == r) {
                row_entries.push_back({ entry.first.first, entry.second });
            }
        }

        sort(row_entries.begin(), row_entries.end());

        vector<long long> row;
        for (const auto& entry : row_entries) {
            row.push_back(entry.second);
        }
        result.push_back(row);
    }
    return result;
}

map<pair<long long, long long>, long long> T(const map<pair<long long, long long>, long long>& a) {
    map<pair<long long, long long>, long long> result;
    for (const auto& entry : a) {
        long long q = entry.first.first;
        long long r = entry.first.second;
        result[{-q - r, r}] = entry.second;
    }
    return result;
}

map<pair<long long, long long>, long long> R(const map<pair<long long, long long>, long long>& a) {
    map<pair<long long, long long>, long long> result;
    for (const auto& entry : a) {
        long long q = entry.first.first;
        long long r = entry.first.second;
        result[{-r, q + r}] = entry.second;
    }
    return result;
}

map<pair<long long, long long>, long long> L(const map<pair<long long, long long>, long long>& a) {
    map<pair<long long, long long>, long long> result;
    for (const auto& entry : a) {
        long long q = entry.first.first;
        long long r = entry.first.second;
        result[{q + r, -q}] = entry.second;
    }
    return result;
}

int main() {
    vector<vector<long long>> D6(12, vector<long long>(12, 0));

    for (long long i = 0; i < 6; i++) {
        for (long long j = 0; j < 6; j++) {
            D6[i][j] = (i + j) % 6;
        }
    }

    for (long long i = 0; i < 6; i++) {
        for (long long j = 6; j < 12; j++) {
            D6[i][j] = (i + j) % 6 + 6;
        }
    }

    for (long long i = 6; i < 12; i++) {
        for (long long j = 6; j < 12; j++) {
            D6[i][j] = (i - j) % 6;
            if (D6[i][j] < 0) D6[i][j] += 6;
        }
    }

    for (long long i = 6; i < 12; i++) {
        for (long long j = 0; j < 6; j++) {
            D6[i][j] = ((j - 6 - i) % 6) + 6;
            if (D6[i][j] < 6) D6[i][j] += 6;
        }
    }

    map<string, long long> mapping = { {"R", 1}, {"L", 5}, {"T", 6} };
    map<long long, string> how = {
        {0, ""}, {1, "R"}, {2, "RR"}, {3, "RRR"}, {4, "LL"}, {5, "L"},
        {6, "T"}, {7, "TR"}, {8, "TRR"}, {9, "TRRR"}, {10, "TLL"}, {11, "TL"}
    };

    long long n;
    cin >> n;

    vector<vector<long long>> a(2 * n - 1);
    for (long long i = 0; i < 2 * n - 1; i++) {
        a[i].resize(2 * n - 1 - abs(i - (n - 1)));
        for (long long j = 0; j < a[i].size(); j++) {
            cin >> a[i][j];
        }
    }

    string s;
    cin >> s;

    long long composition = 0;
    for (char c : s) {
        string char_str(1, c);
        composition = D6[composition][mapping[char_str]];
    }

    auto coords = to_coords(a);
    string transformation = how[composition];

    for (char c : transformation) {
        if (c == 'R') {
            coords = R(coords);
        }
        else if (c == 'L') {
            coords = L(coords);
        }
        else if (c == 'T') {
            coords = T(coords);
        }
    }

    auto result = to_sota(coords);

    for (const auto& row : result) {
        for (long long val : row) {
            cout << val << " ";
        }
        cout << endl;
    }
}
