#include <iostream>
#include <vector>
#include <map>
#include <string>
#include <algorithm>

using namespace std;

map<pair<int, int>, int> to_coords(const vector<vector<int>>& a) {
    map<pair<int, int>, int> coords;
    int n = a.size();
    int mid = n / 2;

    for (int i = 0; i < n; i++) {
        int start = -mid + max(0, mid - i);
        for (int j = 0; j < a[i].size(); j++) {
            int q = start + j;
            int r = i - mid;
            coords[{q, r}] = a[i][j];
        }
    }
    return coords;
}

vector<vector<int>> to_sota(const map<pair<int, int>, int>& coords) {
    vector<int> rs;
    for (const auto& entry : coords) {
        rs.push_back(entry.first.second);
    }

    if (rs.empty()) {
        return {};
    }

    int min_r = *min_element(rs.begin(), rs.end());
    int max_r = *max_element(rs.begin(), rs.end());

    vector<vector<int>> result;
    for (int r = min_r; r <= max_r; r++) {
        vector<pair<int, int>> row_entries;
        for (const auto& entry : coords) {
            if (entry.first.second == r) {
                row_entries.push_back({ entry.first.first, entry.second });
            }
        }

        sort(row_entries.begin(), row_entries.end());

        vector<int> row;
        for (const auto& entry : row_entries) {
            row.push_back(entry.second);
        }
        result.push_back(row);
    }
    return result;
}

map<pair<int, int>, int> T(const map<pair<int, int>, int>& a) {
    map<pair<int, int>, int> result;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        result[{-q - r, r}] = entry.second;
    }
    return result;
}

map<pair<int, int>, int> R(const map<pair<int, int>, int>& a) {
    map<pair<int, int>, int> result;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        result[{-r, q + r}] = entry.second;
    }
    return result;
}

map<pair<int, int>, int> L(const map<pair<int, int>, int>& a) {
    map<pair<int, int>, int> result;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        result[{q + r, -q}] = entry.second;
    }
    return result;
}

int main() {
    vector<vector<int>> D6(12, vector<int>(12, 0));

    for (int i = 0; i < 6; i++) {
        for (int j = 0; j < 6; j++) {
            D6[i][j] = (i + j) % 6;
        }
    }

    for (int i = 0; i < 6; i++) {
        for (int j = 6; j < 12; j++) {
            D6[i][j] = (i + j) % 6 + 6;
        }
    }

    for (int i = 6; i < 12; i++) {
        for (int j = 6; j < 12; j++) {
            D6[i][j] = (((i - j) % 6) + 6) % 6;
            if (D6[i][j] < 0) D6[i][j] += 6;
        }
    }

    for (int i = 6; i < 12; i++) {
        for (int j = 0; j < 6; j++) {
            D6[i][j] = ((((j - 6 - i) % 6) + 6) % 6) + 6;
            if (D6[i][j] < 6) D6[i][j] += 6;
        }
    }

    map<string, int> mapping = { {"R", 1}, {"L", 5}, {"T", 6} };
    map<int, string> how = {
        {0, ""}, {1, "R"}, {2, "RR"}, {3, "RRR"}, {4, "LL"}, {5, "L"},
        {6, "T"}, {7, "TR"}, {8, "TRR"}, {9, "TRRR"}, {10, "TLL"}, {11, "TL"}
    };

    int n;
    cin >> n;

    vector<vector<int>> a(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        a[i].resize(2 * n - 1 - abs(i - (n - 1)));
        for (int j = 0; j < a[i].size(); j++) {
            cin >> a[i][j];
        }
    }

    string s;
    cin >> s;

    int composition = 0;
    for (char c : s) {
        string char_str(1, c);
        composition = D6[composition][mapping[char_str]];
    }

    auto coords = to_coords(a);
    string transformation = how[composition];

    for (char c : transformation) {
        if (c == 'R') {
            coords = R(coords);
        }
        else if (c == 'L') {
            coords = L(coords);
        }
        else if (c == 'T') {
            coords = T(coords);
        }
    }

    auto result = to_sota(coords);


    for (const auto& row : result) {
        for (int val : row) {
            cout << val << " ";
        }
        cout << endl;
    }

    return 0;
}
