#include <iostream>
#include <unordered_set>
#include <vector>
#include <set>
#include <map>
#include <algorithm>

using namespace std;

#define int long long

const int MOD = 1e9 + 7;

int fast_pow(int a, int n, int mod) {
    int res = 1;
    while (n > 0) {
        if (n & 1) {
            res *= a;
            res %= mod;
        }
        a *= a;
        a %= mod;
        n >>= 1;
    }
    return res;
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int t;
    cin >> t;
    vector<int> factorial(2000100,1);
    for (int i = 2; i <= 2000100; i++) {
        factorial[i] = (factorial[i - 1] * i) % MOD;
    }
    while (t--) {
        int p, m;
        cin >> p >> m;
        int upper = (2 * p + m + 1) * fast_pow(4, p, MOD);
        upper %= MOD;
        int lower = 1;
        lower *= factorial[2 * p];
        lower %= MOD;
        upper *= factorial[p];
        upper %= MOD;
        upper *= factorial[p];
        upper %= MOD;
        lower *= (2 * p + 1);
        lower %= MOD;
        cout << upper * fast_pow(lower, MOD - 2, MOD) % MOD << endl;
    }
}
