#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <cmath>
#include <map>
#include <set>
#include <queue>
#include <stack>
#include <unordered_map>
#include <unordered_set>
#include <functional>
#include <numeric>
#include <bitset>

using namespace std;

using ll = long long;
using ld = long double;
using pi = pair<int, int>;
using pl = pair<ll, ll>;
using pi128 = pair<__int128, __int128>;
using i128 = __int128;
using vi = vector<int>;
using vl = vector<long long>;

#define YES std::cout << "YES\n"
#define NO std::cout << "NO\n"
#define debug(x) std::cout << x << '\n'
#define nl '\n'
#define FOR(x, y) for (int x = 0; x < y; x++)
#define FORinv(x, y) for (int x = y - 1; x > -1; x--)

struct pt
{
    double x, y;
};

bool cmp(pt a, pt b)
{
    return a.x < b.x || a.x == b.x && a.y < b.y;
}

bool cw(pt a, pt b, pt c)
{
    return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y) < 0;
}

bool ccw(pt a, pt b, pt c)
{
    return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y) > 0;
}

void convex_hull(vector<pt> &a)
{
    if (a.size() == 1)
        return;
    sort(a.begin(), a.end(), &cmp);
    pt p1 = a[0], p2 = a.back();
    vector<pt> up, down;
    up.push_back(p1);
    down.push_back(p1);
    for (size_t i = 1; i < a.size(); ++i)
    {
        if (i == a.size() - 1 || cw(p1, a[i], p2))
        {
            while (up.size() >= 2 && !cw(up[up.size() - 2], up[up.size() - 1], a[i]))
                up.pop_back();
            up.push_back(a[i]);
        }
        if (i == a.size() - 1 || ccw(p1, a[i], p2))
        {
            while (down.size() >= 2 && !ccw(down[down.size() - 2], down[down.size() - 1], a[i]))
                down.pop_back();
            down.push_back(a[i]);
        }
    }
    a.clear();
    for (size_t i = 0; i < up.size(); ++i)
        a.push_back(up[i]);
    for (size_t i = down.size() - 2; i > 0; --i)
        a.push_back(down[i]);
}

void solution(vector<pt> &in)
{
    convex_hull(in);
    double max_dist = 0;
    vector<pt> points(2);
    for (int i = 0; i < in.size(); ++i)
    {
        // A = vect_x  B = -vect_y  C = -vect_y * in[i].x + vect_x * in[i].y

        for (int j = 0; j < in.size(); ++j)
        {
            pt vect = {in[j].x - in[i].x, in[j].x - in[j].y};

            double dist = sqrt(pow(vect.x, 2) + pow(vect.y, 2));
            if (dist > max_dist)
            {
                points[0] = in[i];
                points[1] = in[j];
                max_dist = dist;
            }
        }
    }
    pt first = points[0];
    pt second = points[1];
    pt d_vec{second.x - first.x, second.y - first.y};
    double A = d_vec.y;
    double B = -d_vec.x;
    pt vec{A, B};
    vector<vector<double>> res(2);
    // A = vect_x  B = -vect_y  C = -vect_y * in[i].x + vect_x * in[i].y

    res[0] = {vec.x,
              vec.y,
              -vec.y * points[0].x + vec.x * points[0].y};

    res[1] = {vec.x,
              vec.y,
              -vec.y * points[1].x + vec.x * points[1].y};
    for (auto el : res[0])
    {
        cout << el << " ";
    }
    cout << endl;

    for (auto el : res[1])
    {
        cout << el << " ";
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;
    vector<pt> in;
    while (n--)
    {
        double x, y;
        cin >> x >> y;
        pt point{x, y};
        in.push_back(point);
    }
    solution(in);

    return 0;
}
