#pragma GCC optimize("O3")

#include <algorithm>
#include <cinttypes>
#include <cstdint>
#include <iostream>
#include <vector>

using namespace std;

template <typename T, typename U>
__attribute__((always_inline)) inline void insert_sorted(std::vector<T> &vec,
                                                         const U &value) {
  auto it = std::upper_bound(vec.begin(), vec.end(), value);
  vec.insert(it, value);
}

#pragma GCC target("bmi,bmi2,avx2")
int main() {
  long long n, s;

  vector<int32_t> V;
  bool a[999984] = {};
  V.reserve(110000);

  cin >> n >> s;

  int32_t min_set = s;
  int32_t max_set = s;

  s = (s * 618023 + 1) % 999983;

  V.emplace_back(s);
  a[s] = true;

  for (long long i = 1; i < n; i++) {
    s = (s * 618023 + 1) % 999983;

    long long j = 0;

    auto b = lower_bound(V.begin(), V.end(), s - V.back());
    auto e = upper_bound(V.begin(), V.end(), s - V.front());

    for (; b < e; ++b) {
      const auto v = *b;
      const auto dif = s - v;

      if (dif < v) {
        break;
      }

      if (a[dif]) {
        j++;
      }
    }

    if (j % 2 == 0 && !a[s]) {
      a[s] = true;
      insert_sorted(V, s);
    }
  }

  cout << V.size();

  return 0;
}
