#pragma GCC optimize("O3")
#include <bitset>
#include <iostream>
#include <set>
#include <vector>
#include <algorithm>
#include <exception>
#include <cinttypes>

using namespace std;

template<typename T, typename U>
void insert_sorted(std::vector<T>& vec, const U& value) {
    auto it = std::upper_bound(vec.begin(), vec.end(), value);
    vec.insert(it, value);
}

#pragma GCC target("bmi,bmi2,avx2")
int main() {
    long long n, s;

    vector<int32_t> V;
    bitset<999984> a;
    V.reserve(110000); 

    cin >> n >> s;

    for (long long i = 0; i < n; i++) {
        s = (s * 618023 + 1) % 999983;

        long long j = 0;

        for (const auto v : V) {
            if (s - v < v) {
                break;
            }

            if (a._Unchecked_test(s - v)) {
                j++;
            }
        }

        if (j % 2 == 0 && !a._Unchecked_test(s)) {
            a._Unchecked_set(s);
            insert_sorted(V, s);
        }
    }

    cout << V.size();

    return 0;
}
