#include <time.h>
 
#include <algorithm>
#include <cassert>
#include <chrono>
#include <cmath>
#include <complex>
#include <cstring>
#include <fstream>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <bitset>
using namespace std::chrono;
 
#define all(x) x.begin(), x.end()
 
using namespace std;
 
typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<bool> vb;
typedef vector<pi> vpi;
 
bool inside(ll value, ll left, ll right) {
  return (left <= value && value <= right);
}
 
ll gcd(ll a, ll b) {
  while (b > 0) {
    ll tmp = b;
    b = a % b;
    a = tmp;
  }
  return a;
}
 
ll bin_pow(ll a, ll exp, ll mod) {
  ll res = 1;
  while (exp) {
    if (exp & 1) res = (res * a) % mod;
    a = (a * a) % mod;
    exp >>= 1;
  }
  return res;
}
 
int inverse(int a, int m) {
  int g = m, r = a, x = 0, y = 1;
  while (r != 0) {
    int q = g / r;
    g %= r;
    swap(g, r);
    x -= q * y;
    swap(x, y);
  }
  return x < 0 ? x + m : x;
}
 
const int INF = 2e9 + 1;
const ll LINF = 9e18;
const int MOD = 1e9 + 7;  // 1e9 + 7;
const int N = 2e7 + 500, M = 700;
 
ll mulmod(ll a, ll b, ll mod) {
  ll x = 0, y = a % mod;
  while (b > 0) {
    if (b % 2 == 1) {
      x = (x + y) % mod;
    }
    y = (y * 2) % mod;
    b /= 2;
  }
  return x % mod;
}
 
void pre(vector<ll>& a, vector<ll>& b, int limit, ll mod) {
    a.reserve(limit / 2 + 2);
    b.reserve(limit / 2 + 2);

    a.push_back(1);
    for (ll i = 2; i <= limit; i += 2) {
        a.push_back((a.back() * i) % mod);
    }
    
    b.push_back(1);
    b.push_back(1);
    for (ll i = 3; i < limit + 2; i += 2) {
        b.push_back((b.back() * i) % mod);
    }
}
void solve() {
  static vector<ll> a;
  static vector<ll> b;
  static bool flag = false;

  if (!flag) {
    pre(a, b, 2000002, MOD);
    flag = true;
  }
   
  int p, m;
  cin >> p >> m;

  if (p == 0) {
      cout << (m + 1) % MOD << '\n';
      return;
  }
  
  ll a_p = (a[p] * bin_pow(b[p], MOD - 2, MOD)) % MOD;
  ll q = ((1LL * m + 2LL * p + 1LL) % MOD * bin_pow(2LL * p + 1LL, MOD - 2, MOD)) % MOD;
  ll ans = (a_p * q) % MOD;
  cout << ans << '\n';
} 
int main() {
  ios_base::sync_with_stdio(false), cin.tie(0);
#ifdef LOCAL
  freopen("input.in", "r", stdin);
#endif
  int t = 1;
  cin >> t;
  for (int i = 0; i < t; i++) {
    string s = "Testcase #";
    // s += ('0' + i);
    // print(s, 2);
    solve();
    // print("-----------\n");
  }
}