// #pragma GCC optimize("Ofast,unroll-loops")
#include <bits/stdc++.h>
// #pragma GCC target("avx2,sse")
using namespace std;
#define int long long
using ll = long long;

struct pt {
    int x, y;

    friend pt operator-(const pt &a, const pt &b) {
        return {a.x - b.x, a.y - b.y};
    }

    int norm2() const {
        return x * x + y * y;
    }

    pt perp() const {
        return {-y, x};
    }
};

int cross(pt a, pt b) {
    return a.x * b.y - a.y * b.x;
}

array<int, 3> get_ABC(pt a, pt b) {
    pt v = (a - b).perp();
    int A = v.x, B = v.y;
    int C = -(A * a.x + B * a.y);
    return {A, B, C};
}

int sq(int x) {
    return x * x;
}

pair<int, int> get_dist(pt p, int A, int B, int C) {
    assert(A*A+B*B>0);
    return {sq(p.x * A + p.y * B + C), A * A + B * B};
}

void solve() {
    int n;
    cin >> n;
    vector<pt> a(n);
    for (auto& [x, y] : a) cin >> x >> y;
    int pos = 0;
    for (int i = 1; i < n; ++i) {
        if (a[i].y < a[pos].y || a[i].y == a[pos].y && a[i].x < a[pos].x)
            pos = i;
    }
    pt O = a[pos];
    a.erase(a.begin() + pos);
    sort(a.begin(), a.end(), [&](pt a, pt b) {
        if (cross(a - O, b - O) == 0)
            return (a - O).norm2() < (b - O).norm2();
        return cross(a - O, b - O) > 0;
    });
    vector<pt> hp{O};
    for (auto& p : a) {
        while (hp.size() >= 2 && cross(hp.back() - hp[hp.size() - 2], p - hp.back()) <= 0) {
            hp.pop_back();
        }
        hp.push_back(p);
    }
    a.push_back(O);
    int A = -1, B = -1, C = -1;
    int up = -1, down = -1;
    int sz = hp.size();
    for (int i = 0; i < sz; ++i) {
        auto [AA, BB, CC] = get_ABC(hp[i], hp[(i + 1) % sz]);
        int cur_up = 0, cur_down = 1;
        for (int j = 0; j < n; ++j) {
            auto [upp, downn] = get_dist(a[j], AA, BB, CC);
            if ((__int128)cur_up * downn < (__int128)upp * cur_down) {
                cur_up = upp, cur_down = downn;
            }
        }
        if (up == -1 || (__int128)up * cur_down < (__int128)down * cur_up) {
            up = cur_up;
            down = cur_down;
            A = AA, B = BB, C = CC;
        }
    }
    cout << A << " " << B << " " << C << "\n";
}

int32_t main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(10);

    // freopen("input.txt", "r", stdin);
    // freopen("output.txt", "w", stdout);

    int T = 1;
    while (T--)
        solve();

    return 0;
}
