#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>

void fast_io() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
}

namespace NTT {
    const int MOD = 998244353;
    const int G = 3;

    long long power(long long base, long long exp) {
        long long res = 1;
        base %= MOD;
        while (exp > 0) {
            if (exp % 2 == 1) res = (res * base) % MOD;
            base = (base * base) % MOD;
            exp /= 2;
        }
        return res;
    }

    long long modInverse(long long n) {
        return power(n, MOD - 2);
    }

    void ntt(std::vector<long long>& a, bool invert) {
        int n = a.size();
        for (int i = 1, j = 0; i < n; i++) {
            int bit = n >> 1;
            for (; j & bit; bit >>= 1)
                j ^= bit;
            j ^= bit;
            if (i < j)
                std::swap(a[i], a[j]);
        }

        for (int len = 2; len <= n; len <<= 1) {
            long long wlen = power(G, (MOD - 1) / len);
            if (invert) wlen = modInverse(wlen);
            for (int i = 0; i < n; i += len) {
                long long w = 1;
                for (int j = 0; j < len / 2; j++) {
                    long long u = a[i + j], v = (a[i + j + len / 2] * w) % MOD;
                    a[i + j] = (u + v) % MOD;
                    a[i + j + len / 2] = (u - v + MOD) % MOD;
                    w = (w * wlen) % MOD;
                }
            }
        }
        if (invert) {
            long long n_inv = modInverse(n);
            for (long long& x : a)
                x = (x * n_inv) % MOD;
        }
    }

    std::vector<long long> multiply(const std::vector<char>& a_bool, const std::vector<char>& b_bool, int required_size) {
        std::vector<long long> a(a_bool.begin(), a_bool.end());
        std::vector<long long> b(b_bool.begin(), b_bool.end());
        int n = 1;
        while (n < required_size) n <<= 1;
        a.resize(n);
        b.resize(n);

        ntt(a, false);
        ntt(b, false);
        for (int i = 0; i < n; i++) a[i] = (a[i] * b[i]) % MOD;
        ntt(a, true);

        a.resize(required_size);
        return a;
    }
}

const int PROBLEM_MOD = 999983;

int main() {
    fast_io();
    int n;
    long long s;
    std::cin >> n >> s;

    const int BLOCK_SIZE = 500;
    int total_elements = 0;

    std::vector<char> p_total(PROBLEM_MOD, 0);
    std::vector<char> p_main(PROBLEM_MOD, 0);
    std::vector<long long> conv_main(2 * PROBLEM_MOD, 0);
    std::vector<int> v_block;
    v_block.reserve(BLOCK_SIZE);

    std::vector<char> p_in_block_cache(PROBLEM_MOD, 0);

    for (int i = 0; i < n; ++i) {
        if (i > 0 && i % BLOCK_SIZE == 0) {
            if (!v_block.empty()) {
                std::vector<char> p_block(PROBLEM_MOD, 0);
                for (int val : v_block) p_block[val] = 1;

                auto conv_main_block = NTT::multiply(p_main, p_block, 2 * PROBLEM_MOD - 1);
                auto conv_block_block = NTT::multiply(p_block, p_block, 2 * PROBLEM_MOD - 1);

                for (size_t k = 0; k < conv_main.size(); ++k) {
                    long long term1 = (k < conv_main_block.size()) ? (2 * conv_main_block[k]) : 0;
                    long long term2 = (k < conv_block_block.size()) ? conv_block_block[k] : 0;
                    conv_main[k] += term1 + term2;
                }

                for (int val : v_block) p_main[val] = 1;
                v_block.clear();
            }
        }

        s = (s * 618023LL + 1) % PROBLEM_MOD;
        int cs = s;

        long long pairs_count = 0;

        pairs_count += conv_main[cs];

        if (i % BLOCK_SIZE == 0) {
             for(int j=0; j < PROBLEM_MOD; ++j) p_in_block_cache[j] = 0;
        }

        for (int a : v_block) {
            int b = cs - a;
            if (b >= 0 && b < PROBLEM_MOD && p_main[b]) {
                pairs_count += 2;
            }
        }

        for (int a : v_block) {
            int b = cs - a;
            if (b >= 0 && b < PROBLEM_MOD && p_in_block_cache[b]) {
                pairs_count++;
            }
        }

        long long distinct_pairs = pairs_count;
        if (cs % 2 == 0 && p_total[cs / 2]) {
            distinct_pairs++;
        }
        distinct_pairs /= 2;

        if (distinct_pairs % 2 == 0) {
            if (!p_total[cs]) {
                p_total[cs] = 1;
                v_block.push_back(cs);
                p_in_block_cache[cs] = 1;
                total_elements++;
            }
        }
    }

    std::cout << total_elements << std::endl;

    return 0;
}
