#include <iostream>
#include <string>
#include <cstdint>
#include <algorithm>
using namespace std;

static inline uint32_t mod_pow2(const string& s, int K) {
    uint32_t m = (uint32_t(1) << K) - 1u, r = 0;
    for (char c : s) r = ((r * 10u) + uint32_t(c - '0')) & m;
    return r;
}

static inline int v2_of_3x1_mod2K(uint32_t m, int K) {
    uint32_t y = 3u*m + 1u;
    int k = 0; 
    while ((y & 1u) == 0u && k < K) { 
        y >>= 1; 
        ++k; 
    } 
    return k;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t; if (!(cin >> t)) return 0;

    constexpr int K = 12;
    constexpr int R_CAP = 3;
    constexpr int L_CAP = 19;

    for (int round = 0; round < t; ++round) {
        string x; if (!(cin >> x)) return 0;
        if (x == "0") return 0;

        int consecRandom = 0;
        while (x != "1") {
            if (x == "0") return 0;

            bool even = (((x.back() - '0') & 1) == 0);
            bool useRandom = false;

            if (!even) {
                uint32_t m = mod_pow2(x, K);
                int k = v2_of_3x1_mod2K(m, K);
                if (k <= 2 && consecRandom < R_CAP && x.size() < size_t(L_CAP))
                    useRandom = true;
            }

            if (even || !useRandom) {
                cout << "Collatz\n" << flush;
                consecRandom = 0;
                if (!(cin >> x)) return 0;
            } else {
                cout << "RANDOM\n" << flush;
                ++consecRandom;
                string random_num;
                if (!(cin >> random_num)) return 0;
                if (!(cin >> x)) return 0;
            }
        }
    }
    return 0;
}
