#include <bits/stdc++.h>
using namespace std;

struct Coords {
    int x, y, z;
};

Coords r_k(const Coords& c, int k) {
    switch (k) {
        case 0: return c;
        case 1: return {-c.z, -c.x, -c.y};
        case 2: return {c.y, c.z, c.x};
        case 3: return {-c.x, -c.y, -c.z};
        case 4: return {c.z, c.x, c.y};
        case 5: return {-c.y, -c.z, -c.x};
    }
    return c;
}

Coords t(const Coords& c, int n) {
    int ncol = (2 * n - 1) - abs(c.z);
    int x_st = max(-(n - 1), -c.z - (n - 1));
    int current_col = c.x - x_st;
    int new_col = ncol - 1 - current_col;
    int xn = x_st + new_col;
    int yn = -xn - c.z;
    return {xn, yn, c.z};
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;

    vector<vector<int>> arr(2 * n - 1, vector<int>(2 * n - 1, -1));
    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int ncol = 2 * n - 1 - abs(z);
        int x_st = max(-(n - 1), -z - (n - 1));
        for (int c = 0; c < ncol; ++c) {
            int x = x_st + c;
            cin >> arr[x + n - 1][z + n - 1];
        }
    }

    string s;
    cin >> s;

    int k = 0;
    bool flip = false;
    for (char op : s) {
        if (op == 'T') {
            flip = !flip;
        } else if (op == 'R') {
            k = flip ? (k + 5) % 6 : (k + 1) % 6;
        } else if (op == 'L') {
            k = flip ? (k + 1) % 6 : (k + 5) % 6;
        }
    }

    for (int r = 0; r < 2 * n - 1; ++r) {
        int z = r - (n - 1);
        int ncol = 2 * n - 1 - abs(z);
        int x_st = max(-(n - 1), -z - (n - 1));
        for (int c = 0; c < ncol; ++c) {
            int x = x_st + c;
            int y = -x - z;
            Coords current = {x, y, z};
            if (flip) {
                current = t(current, n);
            }
            current = r_k(current, (6 - k) % 6);
            cout << arr[current.x + n - 1][current.z + n - 1];
            if (c < ncol - 1) {
                cout << " ";
            }
        }
        cout << "\n";
    }

    return 0;
}