#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

int main() {
    ios::sync_with_stdio(false);

    string notes = "ABCDEFG";
    vector<char> piano(52);
    for (int i = 0; i < 52; i++)
        piano[i] = notes[i % 7];

    unordered_map<char, vector<int>> pos;
    for (int i = 0; i < 52; i++)
        pos[piano[i]].push_back(i);

    int t;
    cin >> t;
    while (t--) 
    {
        string s;
        cin >> s;

        vector<int> cur = pos[s[0]];

        bool ok = true;

        for (int i = 1; i < s.size(); i++) 
        {
            vector<int> next_pos;
            for (int x : pos[s[i]])
            {
                for (int y : cur)
                {
                    if (abs(x - y) <= 3) 
                    {
                        next_pos.push_back(x);
                        break;
                    }
                }
            }
            if (next_pos.empty()) 
            {
                ok = false;
                break;
            }
            cur.swap(next_pos);
        }

        cout << (ok ? "Yes\n" : "No\n");
    }
}
