def solve():
    """
    Исправленное решение задачи "Кто я?"
    
    Ключевое понимание:
    - Первый запуск: n = общее количество игроков
    - Второй запуск: n = количество видимых карт (общее количество игроков = n + 1)
    """
    # Читаем индикатор запуска
    launch = int(input())
    
    if launch == 0:
        # Первый запуск: определяем, какой игрок должен угадать
        n = int(input())  # общее количество игроков
        cards = list(map(int, input().split()))
        
        # Формула для выбора игрока: (сумма всех карт + 1) % n + 1
        total_sum = sum(cards)
        player_to_guess = (total_sum + 1) % n + 1
        print(player_to_guess)
        
    else:
        # Второй запуск: выбранный игрок делает предположение
        player_number = launch
        n = int(input())  # количество видимых карт
        visible_cards = list(map(int, input().split()))
        
        # Вычисляем сумму видимых карт
        visible_sum = sum(visible_cards)
        total_players = n + 1  # общее количество игроков = видимые карты + 1 (своя карта)
        
        # Обратная формула для определения недостающей карты:
        # Исходная формула: (total_sum + 1) % total_players + 1 = player_number
        # Где total_sum = visible_sum + missing_card
        # (visible_sum + missing_card + 1) % total_players + 1 = player_number
        # (visible_sum + missing_card + 1) % total_players = player_number - 1
        # visible_sum + missing_card + 1 = (player_number - 1) + k * total_players
        # missing_card = (player_number - 1 - visible_sum - 1) % total_players
        # missing_card = (player_number - 2 - visible_sum) % total_players
        
        missing_card = (player_number - 2 - visible_sum) % total_players
        print(missing_card)

if __name__ == "__main__":
    solve()
