def solve():
    # Read the launch indicator
    launch = int(input())

    if launch == 0:
        # First launch: determine which player should guess
        n = int(input())
        cards = list(map(int, input().split()))

        # Classic strategy: XOR all card values with their positions
        # to encode which player should guess
        encoded = 0
        for i, card in enumerate(cards):
            encoded ^= card ^ (i + 1)

        # The player to guess is the XOR result modulo n, plus 1
        player_to_guess = (encoded % n) + 1
        print(player_to_guess)

    else:
        # Second launch: the chosen player makes a guess
        player_number = launch
        n = int(input())
        visible_cards = list(map(int, input().split()))

        # Reconstruct what the missing card should be
        # We know that when all cards are XORed with positions,
        # result should be (player_number - 1) mod n

        target = (player_number - 1) % n

        # XOR all visible cards with their "shifted" positions
        # (since the chosen player's position is missing)
        encoded = 0
        pos = 1
        for card in visible_cards:
            if pos == player_number:
                pos += 1  # Skip the guessing player's position
            encoded ^= card ^ pos
            pos += 1

        # The missing card should make the total encoding equal to target
        missing_card = encoded ^ target ^ player_number
        print(missing_card)

if __name__ == "__main__":
    solve()