import sys

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # Use RANDOM only in extreme emergency - very large numbers, many steps
        use_random = (
            x > 10000000 and     # Extremely large numbers only
            step_count > 200 and # After many steps
            step_count % 200 == 0 # Very rarely
        )

        if use_random:
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())

        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

def main():
    t = int(input().strip())

    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()