def modinv(a, mod):
    """Compute modular inverse of a modulo mod using Fermat's little theorem"""
    return pow(a, mod - 2, mod)

def solve():
    MOD = 10**9 + 7
    
    t = int(input())
    for _ in range(t):
        p, m = map(int, input().split())
        
        if p == 0:
            print(0)
            continue
        
        # Use iterative DP instead of recursive with memoization
        # dp[pairs_started][singles_drawn] = expected draws
        max_pairs = p
        max_singles = m
        
        # Initialize DP table
        dp = [[0] * (max_singles + 1) for _ in range(max_pairs + 1)]
        
        # Fill DP table bottom-up
        for pairs_started in range(max_pairs, -1, -1):
            for singles_drawn in range(max_singles, -1, -1):
                remaining_socks = 2 * p + m - pairs_started - singles_drawn
                
                if remaining_socks <= 0:
                    dp[pairs_started][singles_drawn] = 0
                    continue
                
                # Base case: if we have pairs_started > 0 and only those socks remain
                if pairs_started > 0 and pairs_started == remaining_socks:
                    dp[pairs_started][singles_drawn] = 1
                    continue
                
                # We draw one sock for sure
                result = 1
                
                # Case 1: Draw a new single sock
                if singles_drawn < max_singles:
                    prob_single = (m - singles_drawn) * modinv(remaining_socks, MOD) % MOD
                    result = (result + prob_single * dp[pairs_started][singles_drawn + 1]) % MOD
                
                # Case 2: Start a new pair
                if pairs_started < max_pairs:
                    prob_new_pair = (2 * (p - pairs_started)) * modinv(remaining_socks, MOD) % MOD
                    result = (result + prob_new_pair * dp[pairs_started + 1][singles_drawn]) % MOD
                
                dp[pairs_started][singles_drawn] = result
        
        print(dp[0][0])

solve()