#include <bits/stdc++.h>

#define int long long

struct point {
    int x, y;

    point operator-(point a) const {
        return {x - a.x, y - a.y};
    }

    int operator^(point a) const {
        return x * a.y - y * a.x;
    }
};

std::vector<point> convex_hull(std::vector<point> points) {
    if (points.empty()) return {};
    point p0 = points[0];
    for (const point &p: points)
        if (p.x < p0.x || (p.x == p0.x && p.y < p0.y)) {
            p0 = p;
        }
    for (point &x: points) {
        x.x -= p0.x;
        x.y -= p0.y;
    }
    sort(points.begin(), points.end(), [](const point &a, const point &b) {
        int cr = (a ^ b);
        if (cr != 0) {
            return cr > 0;
        }
        return (a.x * a.x + a.y * a.y) < (b.x * b.x + b.y * b.y);
    });
    std::vector<point> hull;
    for (const point &p: points) {
        while (hull.size() >= 2 && ((p - hull.back()) ^ (hull[hull.size() - 2] - hull.back())) <= 0) {
            hull.pop_back();
        }
        hull.push_back(p);
    }
    for (point &x: hull) {
        x.x += p0.x;
        x.y += p0.y;
    }
    return hull;
}

signed main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);
    int n;
    if (!(std::cin >> n)) return 0;
    std::vector<point> points;
    points.reserve(n);
    for (int i = 0; i < n; ++i) {
        int x, y;
        std::cin >> x >> y;
        points.push_back({x, y});
    }
    std::vector<point> hull = convex_hull(points);
    int sz = hull.size();
    if (sz == 0) {
        return 0;
    }
    if (sz == 1) {
        int a = 1, b = 0;
        int c = -(a * hull[0].x + b * hull[0].y);
        std::cout << a << ' ' << b << ' ' << c << '\n';
        std::cout << a << ' ' << b << ' ' << c << '\n';
        return 0;
    }
    int best_d2 = -1;
    int i1 = 0, i2 = 1;
    for (int i = 0; i < sz; ++i) {
        for (int j = i + 1; j < sz; ++j) {
            int dx = hull[i].x - hull[j].x;
            int dy = hull[i].y - hull[j].y;
            int d2 = dx * dx + dy * dy;
            if (d2 > best_d2) {
                best_d2 = d2;
                i1 = i;
                i2 = j;
            }
        }
    }
    int a = hull[i2].x - hull[i1].x;
    int b = hull[i2].y - hull[i1].y;
    int c1 = -(a * hull[i1].x + b * hull[i1].y);
    int c2 = -(a * hull[i2].x + b * hull[i2].y);

    std::cout << a << ' ' << b << ' ' << c1 << '\n';
    std::cout << a << ' ' << b << ' ' << c2 << '\n';
    return 0;
}
